using System;

public class Window
{
	// Konstruktor przyjmuje dwie liczby cakowite, aby
	// okreli pooenie konsoli
	public Window(int top, int left)
	{
		this.top = top;
		this.left = left;
	}

	// Symulacja rysowania okna
	public virtual void DrawWindow()
	{
		Console.WriteLine("Window: rysowanie okna w punkcie {0}, {1}",
		   top, left);
	}

	// Te skadowe s chronione, dlatego s widoczne
	// w metodach klasy pochodnej. Jest to opisane w dalszej
	// czci tego rozdziau. (Zwykle takie skadowe deklaruje si jako prywatne i
	// i opakowuje w chronione waciwoci, ale ta wersja
	// upraszcza przykad.)
	protected int top;
	protected int left;

} // koniec Window

// Klasa ListBox dziedziczy po klasie Window
public class ListBox : Window
{
	// Konstruktor ma nowy parametr 
	// i wywouje konstruktor klasy bazowej
	public ListBox(
	   int top,
	   int left,
	   string contents)
		: base(top, left)
	{
		listBoxContents = contents;
	}

	// Trzeba przesoni wersj klasy bazowej (sowo kluczowe), poniewa 
	// metoda klasy pochodnej dziaa w inny sposb
	public override void DrawWindow()
	{
		base.DrawWindow(); // Wywoanie metody klasy bazowej
		Console.WriteLine("Zapis acucha znakw do kontrolki klasy ListBox: {0}",
		   listBoxContents);
	}

	private string listBoxContents; // Nowa zmienna skadowa
} // Koniec ListBox

public class Button : Window
{
	public Button(
	   int top,
	   int left)
		: base(top, left)
	{ }

	// Trzeba przesoni wersj klasy bazowej (sowo kluczowe), poniewa 
	// metoda klasy pochodnej dziaa w inny sposb
	public override void DrawWindow()
	{
		Console.WriteLine("Rysowanie przycisku w punkcie {0}, {1}\n",
		   top, left);
	}
} // Koniec Button

public class Tester
{
	static void Main()
	{
		Window win = new Window(1, 2);
		ListBox lb = new ListBox(3, 4, "Samodzielna kontrolka klasy ListBox");
		Button b = new Button(5, 6);
		win.DrawWindow();
		lb.DrawWindow();
		b.DrawWindow();

		Window[] winArray = new Window[3];
		winArray[0] = new Window(1, 2);
		winArray[1] = new ListBox(3, 4, "Kontrolka klasy ListBox w tablicy");
		winArray[2] = new Button(5, 6);

		for (int i = 0; i < 3; i++)
		{
			winArray[i].DrawWindow();
		} // Koniec for
	} // Koniec Main
} // Koniec Tester
